#!/usr/bin/ruby
# -*- coding: utf-8 -*-
require "openssl"
require "base64"


class Decryption

    # <summary>
    # 文字列の複合化(AES-256-CBC)
    # </summary>
    # <param name="byteDecrypt">複合対象文字列</param>
    # <param name="strDecKey">複合キー文字列</param>
    # <returns>OK:複合化された文字列,NG:""</returns>
    def cipherDecryption(byteDecrypt, strDecKey, strDecIv)
        dec_data = ""

        begin
            dec = OpenSSL::Cipher.new("AES-256-CBC")
            dec.decrypt
            dec.key = decodeFromBase64String(strDecKey)
            dec.iv = decodeFromBase64String(strDecIv)
            dec_data = dec.update(byteDecrypt)
            dec_data << dec.final

        rescue Exception => ex
            p ex
            dec_data = ""
        ensure
            return dec_data
        end
            
    end

    # <summary>
    # Base64にエンコードする
    # </summary>
    # <param name="buff">エンコード対象文字列バイト配列</param>
    # <returns>エンコード結果</returns>
    def encodeToBase64String(buff)
        strBase64 = Base64.encode64(buff.pack("C*"))

        return strBase64
    end

    # <summary>
    # Base64からデコードする
    # </summary>
    # <param name="buff">エンコード文字列</param>
    # <returns>エンコード結果</returns>
    def decodeFromBase64String(buff)
        decBase64 = Base64.decode64(buff)

        return decBase64
    end

end

